function send_email(recipient, N)
% function send_email(N)
% gives you the option to send an email to your instructor and tell him
% what you really did not like about a specific class.

    disp('SEND AN EMAIL COMPLAINT')
    disp('-----------------------')

    try
        %check whether we got mail settings right.
        set_mail_pref(false);
        %get message from user that will go in the mail body
        mail_body = input(['message to ' recipient ': '], 's');
        %send the mail to ronni ...
        sendmail(   recipient, ...                      %recipient
                    ['problem with session N= ' num2str(N)], ...    %subject
                    mail_body);                                     %mail_body
    catch error
        %if an error was thrown it's probably due to wrong mail settings
        %show what the problem is
        disp(sprintf('Trying to fix problem: %s', error.identifier));
        %try to reset the mail_pref
        set_mail_pref(true);
        %recursion in case you did your settings wrong
        send_email(N);
    end        
return

% private / local function that can only be called from within send_email
% makes sure that email can be sent from your computer
% The reset is trying to make sure this is only executed when NO Email or
% Server is set; as an initial check so to say. In case of an error in the
% send_mail function, reset is true, because the settings are obviously
% wrong!
function set_mail_pref(reset)
    if( reset || ...
        strcmp(getpref('Internet', 'E_mail'), '') || ... 
        strcmp(getpref('Internet', 'SMTP_Server'), '') ) 

        emailadd = input('Your Email Address: ', 's');
        smtpserv = input(sprintf('Your SMTP-Server for %s: ', emailadd), 's');

        setpref('Internet', 'E_mail', emailadd);
        setpref('Internet', 'SMTP_Server', smtpserv);
    end
return