#!/bin/tcsh

# This scripts is a puny attempt to hand you something like 'automated' project
# creation. In the current directory it will create a new directory which is 
# the home for your project. In it you'll find a couple directories that I think
# reasonable for a project, but you're welcome to disagree! Change it then! It will also 
# copy the Makefile templates Makefile-project and Makefile-gmt into the correct places of
# your project directory. Now if there was any data, or any GMT script you'd 
# be able to get going.

# Check for correct number of parameters. Give usage hint.
if ($#argv < 1) then
	echo "Usage: $0 <project name>"
	exit
endif

# Check whether project already exists
if (-e $1) then
	echo "Project '$1' exists in $PWD. Choose different name."
	exit 0
endif

# Create project directory
echo "creating project $1"
mkdir $1

# create initial directory structure
#    - data: data
#    - documentation: doc
#    - maps: gmt
#    - paper: paper
#    - source files: src
#    - website: www

mkdir $1/data $1/doc $1/gmt $1/paper $1/src $1/www

# copy master Makefile into project directory
cp Makefile-project $1/Makefile

# copy mapping Makefile into map directory
cp Makefile-gmt $1/gmt/Makefile



