% try, STATEMENT, catch ME, STATEMENT, end.
% 
% EXAMPLE: file opening

try
    fid  = fopen('whatever.txt', 'r'); % open a non-existing file
    data = fread(fid);                 % now try to get its data
catch myException                      % any name for error message object
    %let the user know, implement graceful program termination ...
    disp(myException);                 % display full error object
    disp(myException.message);         % actual message is more accessible
    disp(myException.stack);           % where did things occur?
end

disp('We do get here!')

%now without try-catch ...
fid  = fopen('whatever.txt', 'r');
data = fread(fid);

disp('We cannot get here!')
