%%
%  Illustrate some basic variable assignments
%

a_row    = [ 1 2 3 4 ]
a_column = [ 1; 2; 3; 4 ]
a_matrix = [ 1 2 3 ; 4 5 6 ; 7 8 9 ]

identity   = eye(4)
some_zeros = zeros(3)
more_zeros = zeros(4,3)
some_ones  = ones(6)

mystring = 'This is a string'
another  = 'Did you notice that it is colored?'

% The function size tells you how many elements a variable has:

size(more_zeros)

% Tou can use the output of size as the input arguments for another
% function

more_ones      = ones( size(more_zeros) )
even_more_ones = ones( 2*size(more_zeros) )


% You can assemble a matrix by columns (or by rows):

col1 = [1; 2; 3]
col2 = [4; 5; 6]
col3 = [7; 8; 9]

my_mat = [col1, col2, col3]

% Multiplication. Two kinds: * and .*

x = [1; 2; 3]
y = [4; 5; 6]

x*y

% No that didn't work. If we transpose x, we'll get a dot product

x'*y

% Or we can multiply each element of x with the correspnding element of y
% using the operator .*

x.*y

%%
% Now let's explore the MATLAB IDE and some of its features

%  Getting help

help matlab

%  Be prepared to wait the first time you do it!

help ops

% Let's look at the IDE for a while

%%
% OK, we're back. Let's use the power of functions and find!
%

has_a_nan = [ 1 2 3 4 NaN 5 6 7 8]
mean(has_a_nan)
2*has_a_nan

isnan(has_a_nan)

real_numbers  = ~isnan(has_a_nan)

has_a_nan(real_numbers)

mean(has_a_nan(real_numbers))

idx = find(has_a_nan > 4)
has_a_nan(idx) = -1*has_a_nan(idx)


%%
%   Now, functions
%


% Let's make our own function.


help class_new_function


x = 2.5
wildval = class_new_function(x)

x1 = linspace(1, 5, 5)
look_a_vector = class_new_function(x1)

x2 = 4*eye(4)
look_a_matrix = class_new_function(x2)

% Here isa a more interesting matrix:

x2 = magic(4)
look_a_matrix = class_new_function(x2)

% Notice the -Inf value where the argument is 1

%%
%  Load and save

save junkdata
clear
load junkdata

% Remember to use a better name than this!


%%
%  structs



dir = '/Users/jeff/Timeseries/alaska2.5_timeseries/';
site = 'GUS2';
file = strcat(dir, site, '.pfiles');
sigtol = [7; 7; 12];
timeseries = read_timeseries(file, sigtol);


% And another! Note that the three dots at the end of the line means the
%  command continues on the next line of the file.

weather = struct( 'year', 2009, 'day_of_year', {225, 230, 235}, ...
    'temp', {64, 69, 58}, 'pressure', {30.1, 30.5, 29.5}, ...
    'humidity', {0.64, 0.34, 0.88} )

weather(2).temp

median( [weather.pressure] )


