#!/bin/tcsh

set process_list = ./config/stations_to_process

foreach file ( ./data/*.dat )
	set station = `echo $file | awk '{print substr($0,15,4)}'`
	if ( `grep $station $process_list | wc -l` > 0 ) then
		set base = `basename $file .dat`
		echo "Processing file $file from station $station"
		if ( ! -e ./data/${base}.jpg ) then
			process_file $file
		endif
	endif
end
