% try, STATEMENT, catch ME, STATEMENT, end.
% EXAMPLE: file opening
clc;
try
    fid  = fopen('whatever.txt', 'r'); % open a non-existing file
    data = fread(fid);                 % now try to get its data
    fclose(fid)
catch myException                      % define any name for an error message object
    %let the user know, implement graceful program termination ... write to stderror
    fprintf(2, '??? Error using ==> fread\n\n')     % recreate Matlab error message
    fprintf(2, '%s\n', myException.message);        % actual message from error message object
    fprintf(2, 'Error in ==> %s at %d\n\n\n', ...   % where did things occur?
                       myException.stack.name, myException.stack.line);

    fprintf(1, 'Simpler:\n')                        % use internal function to get Matlab
    fprintf(2, '%s\n', getReport(myException));     % style report
end

disp('-------> We do get here!'), pause

%now without try-catch ...
fid  = fopen('whatever.txt', 'r');
data = fread(fid);

disp('We cannot get here!')             % We'll only make it here if 'whatever.txt' exists!

