% UAF/GI   Beyond the mouse, fall 2010, Ronni Grapenthin
% EXAMPLE: 2D matrix (Table), prints list of times that can be used for optimal 
% Equinox 2011 preparation
% parameter: miles -- miles you've run

function pace_table = pacing_table(miles)

% Set up pacing table: Give miles as numbers and times as strings (requires a cell array, 
% hence the curly braces)
pace_table = {  1    '0:05:55' '0:08:42' '0:10:55';
                5    '0:30:01' '0:44:06' '0:55:21';
                10   '0:59:56' '1:28:01' '1:50:29';
                15   '1:35:01' '2:19:33' '2:55:05';
                20   '2:04:59' '3:03:34' '3:50:26';
                26.2 '2:40:00' '3:55:00' '4:55:00'};
            
                       
% Since I'm lazy and didn't want to type all the miles, a mile does not equal the index, 
% hence we'll have to do some math. Index is rounded number of miles divided by 5. Since 
% Matlab indices start at 1, we have to add a 1. Otherwise everything smaller than 2.5 miles 
% would result in an error
idx = round(miles/5)+1;
            
% lame output
pace_table(idx,:)
pause

% fancy output:
disp(' ');
disp('   miles    record    well trained  mildly trained');
disp('  ------------------------------------------------------');
disp(pace_table(idx,:));
end