%clear all, close all, clc;

% It's a function now ...
function plot_stations( sta_names )

%create a cell array that contains the names of the three
%GPS stations, BZ09, FAIR and WHIT
%sta_names = {'BZ09', 'FAIR', 'WHIT' };

%iterate over this cell array using it's length as a terminating condition
%this part of the script we want to call 'Initialization' which is the part
%where you get your variables into defined states such that you can then
%later work on them.
for n=1:length(sta_names)
    
    %add a new struct to the array of structs, the struct contains the 5
    %fields: 'time', 'lon', 'lat', 'height', and 'name'
    gps_data(n) = struct('time',   [], 'lon',  [], 'lat', [],...
                         'height', [], 'name', '');

    %add the name of the respective site to the name field 
    gps_data(n).name = sta_names{n};

    %as a temporary variable, create the filename that is linked to the
    %station, i.e. /path/to/STATIONAME.dat
    %populate the rest of the fields by calling read_gps_data, 
    f = ['./' sta_names{n} '.dat'];
    f = sprintf('./%s.dat', sta_names{n});
    f = strcat('./', sta_names{n}, '.dat');
    
    %call the function read_gps_data, presented on Monday in the lecture
    %with the created file name as input parameter and populate the other
    %fields of your structure.
%        [gps_data(n).time, gps_data(n).lon, gps_data(n).lat, ...
%        gps_data(n).height ] = read_gps_data(f);
    
    % If you are done early, consider this:
    % Textread will complain (throw an error) if a file does not exist.
    % Given that you might be dealing with hundreds of stations at a time
    % it would be frustrating to stop possibly lenghty processing whenever 
    % there is a typo in the cell array that holds the sites or certain
    % files are just not there. Guess what: try-catch will help!
    %
    % Try putting the read_gps_data function call in a try-block and 
    % catch possible errors. Give a useful error message (consult last lectures
    % introduction of the try-catch-block and the respective documentation
    % pages for information the error message gives you) OR display your
    % very own error message, i.e. file X does not exist, where X is the
    % parameter you handed to read_gps_data. Then add a fantasy string to
    % the cell array that holds the station names and run your script. You
    % should get at least one empty plot and a meaningful message, but the
    % script should not abort - yeah!
    try
        [gps_data(n).time, gps_data(n).lon, gps_data(n).lat, ...
        gps_data(n).height ] = read_gps_data(f);
    catch file_error
        disp (['WARNING: file ' f ' does not exist.'])
    end
    
    %end your for loop here.
end

%You can imagine that there are quite a few things you could do with this
%array of structs. There are other things you could do after the
%initialization that don't have much to do with the struct. We want to
%leave this up to your imagination. 

% The next thing you will do is plot the timeseries for each GPS station.
% We want you to use a while loop. Not necessarily because it's the best
% thing to do, but just so you do it

% define a counter variable
n=1;

%start your loop over the full length of your struct 
while n<=length(gps_data)
    %call the function, get the figure handle
    h=plot_gps_timeseries(gps_data(n));
    %create output filename
    saveas(h, ['./' gps_data(n).name '.eps'], 'psc2');
    saveas(h, ['./' gps_data(n).name '.png'], 'png');
    %increment your counter!
    n=n+1;
end

%%CONGRATULATIONS, YOU JUST CREATED PUBLISHABLE FIGURES THAT ARE
%%REPRODUCIBLE! AND WE'RE ONLY A MONTH IN THE SEMESTER.
end


