#!/bin/tcsh

# The $# variable contains the number of command line arguments given
# Since we want exactly one argument, we test for this
if( $# != 1) then
	echo "USAGE: $0 DATABASE"
	exit 1
endif

# define the database we want to work on, first command line argument
set db = $1
	
# now we need to check whether the file exists, or else give an error:
if (-e $db) then
	# tell the user what we're working on.
	echo "Using database: $db"

	# get a unique station list from our database
	set sta_list = `awk '{print $1}' $db | sort -u`

	# define empty string which will eventually hold all stations to define 
	# a matlab cell array
	set matlab_cell = " "

	# iterate over the station list and create a new data file for each site
	foreach sta ( $sta_list )
		echo "Working on station $sta ..."
		grep $sta $db | awk '{print $2,$6,$7,$8}' > ${sta}.dat

		# append the current station to the matlab_cell string; $sta needs to be 
		# in single quotes to indicate that it's a string in Matlab. If the 
		# single quotes aren't given, MATLAB will think, e.g. BZ01 is a variable
		set matlab_cell="$matlab_cell '$sta'"

	end

	# once all the data files are created, we can call MATLAB to update the plots
	# Note that $matlab_cell needs curly braces around it, to indicate it's a 
	# cell array. 
	matlab -nojvm -nosplash -r "plot_stations( { $matlab_cell } ); exit; "

else
	echo "$0 ERROR: File '$db' does not exist."
	exit 2
endif
