#!/bin/csh
# set plotting parameters
set databox = -R0/48/2/6 set scale = -JX9.0i/6.0i
# scale data from timetags to time (hours) # input format
# 09+019:00:00:00.0000 2.844
# 09+019:00:06:00.0000 2.815
# 09+019:00:12:00.0000 2.780
cat tide.d* | awk '{hour = substr($1,8,2); minute = substr($1,11,2); second = substr($1,13,2); time = hour+(minute + second/60)/60; if (NR > 1 && time < old_time+0) {addhour += 24;} printf"%.2f %.3f\n",time+addhour,$2; old_time=time;}' > hold.data
# plot unfiltered data
cat hold.data | gmt psxy $databox $scale -W1,125 -Bg1a4:hours:/g1a2:meters::."Seattle Tides CG Dock":WeSn -K > filtered1.ps # plot median (30 minute or half hour) filtered data
cat hold.data | gmt filter1d -Fm0.5 -E | gmt psxy $databox $scale -W1,125/250/125 -Bg1a2 -K -O >> filtered1.ps
# plot median then Gaussian (30 minute or half hour) filtered data
cat hold.data | gmt filter1d -Fm0.5 -E | gmt filter1d -Fg4 -E | gmt psxy $databox $scale -W1,250/125/250 -Bg1a2 -O >> filtered1.ps # new plot; plot raw data
cat hold.data | gmt psxy $databox $scale -W1,125 -Bg1a4:hours:/g1a2:meters::."Seattle Tides CG Dock":WeSn -K > filtered2.ps # plot gaussian (0.5, 1, 2, 4 hour filter lengths).
cat hold.data | gmt filter1d -Fg0.5 -E | gmt psxy $databox $scale -W1,125/250/125 -Bg1a2 -K -O >> filtered2.ps
cat hold.data | gmt filter1d -Fg1 -E | gmt psxy $databox $scale -W1,250/125/125 -Bg1a2 -K -O >> filtered2.ps
cat hold.data | gmt filter1d -Fg2 -E | gmt psxy $databox $scale -W1,125/125/250 -Bg1a2 -K -O >> filtered2.ps
cat hold.data | gmt filter1d -Fg4 -E | gmt psxy $databox $scale -W1,250/125/250 -Bg1a2 -O >> filtered2.ps
