%t_debug unit test

clc, clear all, close all

t_debug off;

%t_debug is off, no printing
disp('Testing ''print_debug'' with ''t_debug off'' (Nothing should print):');
print_debug('This should not print');
disp('done.');
disp(' -------------- ');

%calling t_debug without arguments will give you the current setting
disp('Testing ''t_debug'' to display its status:');
t_debug
disp('done.');
disp(' -------------- ');

%turn on with string
disp('Turning ''t_debug on'' and printing using ''print_debug'' with one argument:');
t_debug on
print_debug('t_debug is on');
disp('done.');
disp(' -------------- ');

%turn off using string
disp('Turning ''t_debug off'' and printing using ''print_debug'' with one argument (Nothing should print):');
t_debug off
print_debug('This should not print');
disp('done.');
disp(' -------------- ');

%using numerical values as levels of debugging. A higher level should
%result in a more talkative debugging session.
disp('Testing ''print_debug'' with 2 arguments (level=1) and ''t_debug off'' (Nothing should print):');
print_debug('This should not print', 1);
disp('done.');
disp(' -------------- ');


%calling t_debug without arguments will give you the current setting
disp('Setting ''t_debug(5) '' and printing its status:');
t_debug(5)
t_debug
disp('done.');
disp(' -------------- ');


disp('Testing ''print_debug'' with 2 arguments (level=1...6) and ''t_debug(5)'' (Only 5 levels should print):');
print_debug('Max level is set to 5', 1);
print_debug('Max level is set to 5', 2);
print_debug('Max level is set to 5', 3);
print_debug('Max level is set to 5', 4);
print_debug('Max level is set to 5', 5);
print_debug('This should not print', 6);
print_debug('This should not print', 100);
disp('done.');
disp(' -------------- ');

disp('Printing without level argument should work at t_debug state 5:')
print_debug('No level argument set.');
disp('done.');
disp(' -------------- ');

disp('Testing ''print_debug'' with 2 arguments (level=10) and ''t_debug'' between levels 5 and 15 (Only 15 levels should print):');
print_debug('Max level is set to 5', 10);
print_debug('Max level is set to 5', 10);
print_debug('Max level is set to 5', 10);
t_debug(15)
print_debug('Max level is set to 15', 5);
print_debug('Max level is set to 15', 10);
print_debug('Max level is set to 15', 15);
print_debug('Max level is set to 15', 20);
t_debug(5)
print_debug('Max level is set to 5', 10);
print_debug('Max level is set to 5', 10);
print_debug('Max level is set to 5', 10);
disp('done.');
disp(' -------------- ');

t_debug off;

disp(' ');
disp('Tests are finished. T_DEBUG turned off again.');
disp(' -------------- ');
