function print_debug(the_text, level)

% PRINT_DEBUG
% Takes one parameter which is being printed (using disp) if program is in debug mode.
% To set a program to debug mode use: 
%            t_debug on
% To exit debug mode:
%            t_debug off
%
% To use multi-level debugging output:
%            t_debug(N)             %where N=0..inf
%            print_debug(...,level) %where level <= N
% Here, 
%            N=0 represents 'off', i.e. no debugging output, 
%            N=1 and N=inf represents 'on', i.e. full debugging output
%
%
% Author: Ronni Grapenthin, UAF-GI, AVO
% See also: T_DEBUG
% Modificatons: 2010-08-02 added t_debug_config
%               2010-11-21 added levels

    %check for optional level
    if(nargin > 2)
        error('MATLAB:print_debug:tooManyInputs', ...
              'Too many input arguments (at most one optional)');
    elseif (nargin == 1)
        level = inf;
    elseif (nargin == 0)
        error('MATLAB:print_debug:notEnoughInputs', ...
              'Not enough input arguments (at least one required)');
    end
    
    %load string constants that are shared amongst 
    %various functions.
    load t_debug_config
    
    if( getpref(T_DBG_GROUP, T_DBG_PREF_DEBUG) > 0 && ...
        (level == inf || getpref(T_DBG_GROUP, T_DBG_PREF_DEBUG) >= level) )
            fprintf('DEBUG: ');

            if(level < inf)
                fprintf('(L=%d)\t', level);
            end
            
            disp(the_text)
    end
end
