% read in GPS time series, create arrays, plot them
clear all;
close all;
clc;

% This is where I got the data initially from:

[BZ09_time, BZ09_lon, BZ09_lat, BZ09_height] = textread('BZ09.dat', '%f%f%f%f');
[FAIR_time, FAIR_lon, FAIR_lat, FAIR_height] = textread('FAIR.dat', '%f%f%f%f');
[WHIT_time, WHIT_lon, WHIT_lat, WHIT_height] = textread('WHIT.dat', '%f%f%f%f');

%This is how I saved the whole workspace to a .mat file:
%save('gps_data.mat');

%This is how I load a .mat file that contains all sorts of useful data.
load gps_data;


%plotting, highly inefficient copy'n'pasting.
figure(1)
subplot(3,1,1)
%we've gotta subtract mean values to get useful variation of position values plotted.
plot(BZ09_time, BZ09_lon - mean(BZ09_lon))
title('BZ09 with respect to stable Eurasia')
ylabel('easting (m)');
axis tight;

subplot(3,1,2)
plot(BZ09_time, BZ09_lat - mean(BZ09_lat))
ylabel('northing (m)');
axis tight;

subplot(3,1,3)
plot(BZ09_time, BZ09_height - mean(BZ09_height))
ylabel('height (m)');
xlabel('epoch (year)');
axis tight;

figure(2)
subplot(3,1,1)
plot(FAIR_time, FAIR_lon - mean(FAIR_lon))
title('FAIR with respect to stable North America')
ylabel('easting (m)');

subplot(3,1,2)
plot(FAIR_time, FAIR_lat - mean(FAIR_lat))
ylabel('northing (m)');

subplot(3,1,3)
plot(FAIR_time, FAIR_height - mean(FAIR_height))
ylabel('height (m)');
xlabel('epoch (year)');

figure(3)
subplot(3,1,1)
plot(WHIT_time, WHIT_lon - mean(WHIT_lon))
title('WHIT with respect to stable North America')
ylabel('easting (m)');

subplot(3,1,2)
plot(WHIT_time, WHIT_lat - mean(WHIT_lat))
ylabel('northing (m)');

subplot(3,1,3)
plot(WHIT_time, WHIT_height - mean(WHIT_height))
ylabel('height (m)');
xlabel('epoch (year)');
